// ===============================================																																																																																				
// ADUCRF101 HEADER FILE																																																																																				
// 06th May 2011																																																																																				
// Rev 1.3 																																																																																				
// Rev. B Silicon																																																																																				
// ===============================================																																																																																				



// General Purpose Timer 0

// 16-bit load value
#define          T0LD                                       (*(volatile unsigned short int *) 0x40000000)
#define          T0LD_A                                     0x40000000
// "16-bit timer value, read only."
#define          T0VAL                                      (*(volatile unsigned short int *) 0x40000004)
#define          T0VAL_A                                    0x40000004
// Control Register
#define          T0CON                                      (*(volatile unsigned short int *) 0x40000008)
#define          T0CON_A                                    0x40000008
// Clear interrupt register
#define          T0CLRI                                     (*(volatile unsigned short int *) 0x4000000C)
#define          T0CLRI_A                                   0x4000000C
// Capture Register
#define          T0CAP                                      (*(volatile unsigned short int *) 0x40000010)
#define          T0CAP_A                                    0x40000010
// Status Register
#define          T0STA                                      (*(volatile unsigned short int *) 0x4000001C)
#define          T0STA_A                                    0x4000001C

// General Purpose Timer 1

// 16-bit load value
#define          T1LD                                       (*(volatile unsigned short int *) 0x40000400)
#define          T1LD_A                                     0x40000400
// "16-bit timer value, read only."
#define          T1VAL                                      (*(volatile unsigned short int *) 0x40000404)
#define          T1VAL_A                                    0x40000404
// Control Register
#define          T1CON                                      (*(volatile unsigned short int *) 0x40000408)
#define          T1CON_A                                    0x40000408
// Clear interrupt register
#define          T1CLRI                                     (*(volatile unsigned short int *) 0x4000040C)
#define          T1CLRI_A                                   0x4000040C
// Capture Register
#define          T1CAP                                      (*(volatile unsigned short int *) 0x40000410)
#define          T1CAP_A                                    0x40000410
// Status Register
#define          T1STA                                      (*(volatile unsigned short int *) 0x4000041C)
#define          T1STA_A                                    0x4000041C

// PWM

// PWM Control register
#define          PWMCON0                                    (*(volatile unsigned short int *) 0x40001000)
#define          PWMCON0_A                                  0x40001000
// Trip control register
#define          PWMCON1                                    (*(volatile unsigned char      *) 0x40001004)
#define          PWMCON1_A                                  0x40001004
// PWM interrupt clear. Write to this register clears the latched PWM interrupt.
#define          PWMCLRI                                    (*(volatile unsigned short int *) 0x40001008)
#define          PWMCLRI_A                                  0x40001008
// Compare Register 0 for PWM0 and PWM1 
#define          PWM0COM0                                   (*(volatile unsigned short int *) 0x40001010)
#define          PWM0COM0_A                                 0x40001010
// Compare Register 1 for PWM0 and PWM1
#define          PWM0COM1                                   (*(volatile unsigned short int *) 0x40001014)
#define          PWM0COM1_A                                 0x40001014
// Compare Register 2 for PWM0 and PWM1
#define          PWM0COM2                                   (*(volatile unsigned short int *) 0x40001018)
#define          PWM0COM2_A                                 0x40001018
// Period Value register for PWM0 and PWM1
#define          PWM0LEN                                    (*(volatile unsigned short int *) 0x4000101C)
#define          PWM0LEN_A                                  0x4000101C
// Compare Register 0 for PWM2 and PWM3 
#define          PWM1COM0                                   (*(volatile unsigned short int *) 0x40001020)
#define          PWM1COM0_A                                 0x40001020
// Compare Register 1 for PWM2 and PWM3
#define          PWM1COM1                                   (*(volatile unsigned short int *) 0x40001024)
#define          PWM1COM1_A                                 0x40001024
// Compare Register 2 for PWM2 and PWM3
#define          PWM1COM2                                   (*(volatile unsigned short int *) 0x40001028)
#define          PWM1COM2_A                                 0x40001028
// Period Value register for PWM2 and PWM3
#define          PWM1LEN                                    (*(volatile unsigned short int *) 0x4000102C)
#define          PWM1LEN_A                                  0x4000102C
// Compare Register 0 for PWM4 and PWM5 
#define          PWM2COM0                                   (*(volatile unsigned short int *) 0x40001030)
#define          PWM2COM0_A                                 0x40001030
// Compare Register 1 for PWM4 and PWM5
#define          PWM2COM1                                   (*(volatile unsigned short int *) 0x40001034)
#define          PWM2COM1_A                                 0x40001034
// Compare Register 2 for PWM4 and PWM5
#define          PWM2COM2                                   (*(volatile unsigned short int *) 0x40001038)
#define          PWM2COM2_A                                 0x40001038
// Period Value register for PWM4 and PWM5
#define          PWM2LEN                                    (*(volatile unsigned short int *) 0x4000103C)
#define          PWM2LEN_A                                  0x4000103C
// Compare Register 0 for PWM6 and PWM7 
#define          PWM3COM0                                   (*(volatile unsigned short int *) 0x40001040)
#define          PWM3COM0_A                                 0x40001040
// Compare Register 1 for PWM6 and PWM7
#define          PWM3COM1                                   (*(volatile unsigned short int *) 0x40001044)
#define          PWM3COM1_A                                 0x40001044
// Compare Register 2 for PWM6 and PWM7
#define          PWM3COM2                                   (*(volatile unsigned short int *) 0x40001048)
#define          PWM3COM2_A                                 0x40001048
// Period Value register for PWM6 and PWM7
#define          PWM3LEN                                    (*(volatile unsigned short int *) 0x4000104C)
#define          PWM3LEN_A                                  0x4000104C

// Power Control

// Power modes register
#define          PWRMOD                                     (*(volatile unsigned char      *) 0x40002400)
#define          PWRMOD_A                                   0x40002400
// Key protection for the PWRMOD register.
#define          PWRKEY                                     (*(volatile unsigned short int *) 0x40002404)
#define          PWRKEY_A                                   0x40002404
// Power Supply Monitor control
#define          PSMCON                                     (*(volatile unsigned char      *) 0x40002408)
#define          PSMCON_A                                   0x40002408
// Crystal Oscillator control
#define          XOSCCON                                    (*(volatile unsigned char      *) 0x40002410)
#define          XOSCCON_A                                  0x40002410
// External Interrupt configuration register 0
#define          EI0CFG                                     (*(volatile unsigned short int *) 0x40002420)
#define          EI0CFG_A                                   0x40002420
// External Interrupt configuration register 1
#define          EI1CFG                                     (*(volatile unsigned short int *) 0x40002424)
#define          EI1CFG_A                                   0x40002424
// ADF7023 interrupt configuration register
#define          EI2CFG                                     (*(volatile unsigned short int *) 0x40002428)
#define          EI2CFG_A                                   0x40002428
// External Interrupts Clear register
#define          EICLR                                      (*(volatile unsigned short int *) 0x40002430)
#define          EICLR_A                                    0x40002430
// NMI Clear register
#define          NMICLR                                     (*(volatile unsigned char      *) 0x40002434)
#define          NMICLR_A                                   0x40002434
// Reset Status
#define          RSTSTA                                     (*(volatile unsigned char      *) 0x40002440)
#define          RSTSTA_A                                   0x40002440
// Reset Status Clear
#define          RSTCLR                                     (*(volatile unsigned char      *) 0x40002440)
#define          RSTCLR_A                                   0x40002440

// Watchdog Timer

// Load value.
#define          T3LD                                       (*(volatile unsigned short int *) 0x40002580)
#define          T3LD_A                                     0x40002580
// "Current count value, read only."
#define          T3VAL                                      (*(volatile unsigned short int *) 0x40002584)
#define          T3VAL_A                                    0x40002584
// Control Register
#define          T3CON                                      (*(volatile unsigned short int *) 0x40002588)
#define          T3CON_A                                    0x40002588
// "Clear interrupt, write only."
#define          T3CLRI                                     (*(volatile unsigned short int *) 0x4000258C)
#define          T3CLRI_A                                   0x4000258C
// "Status register, read only."
#define          T3STA                                      (*(volatile unsigned short int *) 0x40002598)
#define          T3STA_A                                    0x40002598

// Wake Up Timer

// Current count value LSB
#define          T2VAL0                                     (*(volatile unsigned short int *) 0x40002500)
#define          T2VAL0_A                                   0x40002500
// Current count value MSB
#define          T2VAL1                                     (*(volatile unsigned short int *) 0x40002504)
#define          T2VAL1_A                                   0x40002504
// Control Register
#define          T2CON                                      (*(volatile unsigned short int *) 0x40002508)
#define          T2CON_A                                    0x40002508
// 12-bit register. Wake up field A
#define          T2INC                                      (*(volatile unsigned short int *) 0x4000250C)
#define          T2INC_A                                    0x4000250C
// Wake up field B  LSB
#define          T2WUFB0                                    (*(volatile unsigned short int *) 0x40002510)
#define          T2WUFB0_A                                  0x40002510
// Wake up field B  MSB
#define          T2WUFB1                                    (*(volatile unsigned short int *) 0x40002514)
#define          T2WUFB1_A                                  0x40002514
// Wake up field C  LSB
#define          T2WUFC0                                    (*(volatile unsigned short int *) 0x40002518)
#define          T2WUFC0_A                                  0x40002518
// Wake up field C  MSB
#define          T2WUFC1                                    (*(volatile unsigned short int *) 0x4000251C)
#define          T2WUFC1_A                                  0x4000251C
// Wake up field D  LSB
#define          T2WUFD0                                    (*(volatile unsigned short int *) 0x40002520)
#define          T2WUFD0_A                                  0x40002520
// Wake up field D  MSB
#define          T2WUFD1                                    (*(volatile unsigned short int *) 0x40002524)
#define          T2WUFD1_A                                  0x40002524
// Interrupt enable
#define          T2IEN                                      (*(volatile unsigned short int *) 0x40002528)
#define          T2IEN_A                                    0x40002528
// Status
#define          T2STA                                      (*(volatile unsigned short int *) 0x4000252C)
#define          T2STA_A                                    0x4000252C
// Clear interrupts. Write only.
#define          T2CLRI                                     (*(volatile unsigned short int *) 0x40002530)
#define          T2CLRI_A                                   0x40002530
// Wake up field A  LSB.
#define          T2WUFA0                                    (*(volatile unsigned short int *) 0x4000253C)
#define          T2WUFA0_A                                  0x4000253C
// Wake up field A MSB.
#define          T2WUFA1                                    (*(volatile unsigned short int *) 0x40002540)
#define          T2WUFA1_A                                  0x40002540

// Clock Control

// System clocking architecture control register
#define          CLKCON                                     (*(volatile unsigned short int *) 0x40002000)
#define          CLKCON_A                                   0x40002000
// System clocking architecture control register
#define          CLKCON0                                    (*(volatile unsigned short int *) 0x40002000)
#define          CLKCON0_A                                  0x40002000

// Flash Interface 0

// Status Register
#define          FEESTA                                     (*(volatile unsigned short int *) 0x40002800)
#define          FEESTA_A                                   0x40002800
// Command Control Register
#define          FEECON0                                    (*(volatile unsigned short int *) 0x40002804)
#define          FEECON0_A                                  0x40002804
// Command register
#define          FEECMD                                     (*(volatile unsigned short int *) 0x40002808)
#define          FEECMD_A                                   0x40002808
// Low Page  (Lower 16 bits)
#define          FEEADR0L                                   (*(volatile unsigned short int *) 0x40002810)
#define          FEEADR0L_A                                 0x40002810
// Low Page  (Upper 16 bits)
#define          FEEADR0H                                   (*(volatile unsigned short int *) 0x40002814)
#define          FEEADR0H_A                                 0x40002814
// Hi Page  (Lower 16 bits)
#define          FEEADR1L                                   (*(volatile unsigned short int *) 0x40002818)
#define          FEEADR1L_A                                 0x40002818
// Hi Page  (Upper 16 bits)
#define          FEEADR1H                                   (*(volatile unsigned short int *) 0x4000281C)
#define          FEEADR1H_A                                 0x4000281C
// Key
#define          FEEKEY                                     (*(volatile unsigned short int *) 0x40002820)
#define          FEEKEY_A                                   0x40002820
// Write Protection (Lower 16 bits)
#define          FEEPROL                                    (*(volatile unsigned short int *) 0x40002828)
#define          FEEPROL_A                                  0x40002828
// Write Protection (Upper 16 bits)
#define          FEEPROH                                    (*(volatile unsigned short int *) 0x4000282C)
#define          FEEPROH_A                                  0x4000282C
// Signature (Lower 16 bits)
#define          FEESIGL                                    (*(volatile unsigned short int *) 0x40002830)
#define          FEESIGL_A                                  0x40002830
// Signature (Upper 16 bits)
#define          FEESIGH                                    (*(volatile unsigned short int *) 0x40002834)
#define          FEESIGH_A                                  0x40002834
// User Setup register
#define          FEECON1                                    (*(volatile unsigned short int *) 0x40002838)
#define          FEECON1_A                                  0x40002838
// Abort address (Lower 16 bits)
#define          FEEADRAL                                   (*(volatile unsigned short int *) 0x40002848)
#define          FEEADRAL_A                                 0x40002848
// Abort address (Upper 16 bits)
#define          FEEADRAH                                   (*(volatile unsigned short int *) 0x4000284C)
#define          FEEADRAH_A                                 0x4000284C
// Lower 16 bits of the sys irq abort enable register.
#define          FEEAEN0                                    (*(volatile unsigned short int *) 0x40002878)
#define          FEEAEN0_A                                  0x40002878
// Upper 16 bits of the sys irq abort enable register.
#define          FEEAEN1                                    (*(volatile unsigned short int *) 0x4000287C)
#define          FEEAEN1_A                                  0x4000287C
// Upper 32..47 bits of the sys irq abort enable register.
#define          FEEAEN2                                    (*(volatile unsigned short int *) 0x40002880)
#define          FEEAEN2_A                                  0x40002880

// I2C

// Master Control Register
#define          I2CMCON                                    (*(volatile unsigned short int *) 0x40003000)
#define          I2CMCON_A                                  0x40003000
// Master Status Register
#define          I2CMSTA                                    (*(volatile unsigned short int *) 0x40003004)
#define          I2CMSTA_A                                  0x40003004
// Master Receive Data
#define          I2CMRX                                     (*(volatile unsigned char      *) 0x40003008)
#define          I2CMRX_A                                   0x40003008
// Master Transmit Data
#define          I2CMTX                                     (*(volatile unsigned char      *) 0x4000300C)
#define          I2CMTX_A                                   0x4000300C
// Master Receive Data Count
#define          I2CMRXCNT                                  (*(volatile unsigned short int *) 0x40003010)
#define          I2CMRXCNT_A                                0x40003010
// Master Current Receive Data Count
#define          I2CMCRXCNT                                 (*(volatile unsigned short int *) 0x40003014)
#define          I2CMCRXCNT_A                               0x40003014
// 1st Master Address Byte
#define          I2CADR0                                    (*(volatile unsigned char      *) 0x40003018)
#define          I2CADR0_A                                  0x40003018
// 2nd Master Address Byte
#define          I2CADR1                                    (*(volatile unsigned char      *) 0x4000301C)
#define          I2CADR1_A                                  0x4000301C
// Serial clock period divisor register
#define          I2CDIV                                     (*(volatile unsigned short int *) 0x40003024)
#define          I2CDIV_A                                   0x40003024
// Slave Control Register
#define          I2CSCON                                    (*(volatile unsigned short int *) 0x40003028)
#define          I2CSCON_A                                  0x40003028
// "Slave I2C Status, Error and IRQ Register"
#define          I2CSSTA                                    (*(volatile unsigned short int *) 0x4000302C)
#define          I2CSSTA_A                                  0x4000302C
// Slave Receive Data Register
#define          I2CSRX                                     (*(volatile unsigned short int *) 0x40003030)
#define          I2CSRX_A                                   0x40003030
// Slave Transmit Data Register
#define          I2CSTX                                     (*(volatile unsigned short int *) 0x40003034)
#define          I2CSTX_A                                   0x40003034
// Hardware General Call ID
#define          I2CALT                                     (*(volatile unsigned short int *) 0x40003038)
#define          I2CALT_A                                   0x40003038
// 1st Slave Address Device ID
#define          I2CID0                                     (*(volatile unsigned short int *) 0x4000303C)
#define          I2CID0_A                                   0x4000303C
// 2nd Slave Address Device ID
#define          I2CID1                                     (*(volatile unsigned short int *) 0x40003040)
#define          I2CID1_A                                   0x40003040
// 3rd Slave Address Device ID
#define          I2CID2                                     (*(volatile unsigned short int *) 0x40003044)
#define          I2CID2_A                                   0x40003044
// 4th Slave Address Device ID
#define          I2CID3                                     (*(volatile unsigned short int *) 0x40003048)
#define          I2CID3_A                                   0x40003048
// Master and Slave Rx/Tx FIFO Status Register
#define          I2CFSTA                                    (*(volatile unsigned short int *) 0x4000304C)
#define          I2CFSTA_A                                  0x4000304C

// SPI 0

// Status Register
#define          SPI0STA                                    (*(volatile unsigned short int *) 0x40004000)
#define          SPI0STA_A                                  0x40004000
// 8-bit Receive register.
#define          SPI0RX                                     (*(volatile unsigned char      *) 0x40004004)
#define          SPI0RX_A                                   0x40004004
// 8-bit Transmit register
#define          SPI0TX                                     (*(volatile unsigned char      *) 0x40004008)
#define          SPI0TX_A                                   0x40004008
// SPI Clock Divider Registers
#define          SPI0DIV                                    (*(volatile unsigned short int *) 0x4000400C)
#define          SPI0DIV_A                                  0x4000400C
// 16-bit configuration register
#define          SPI0CON                                    (*(volatile unsigned short int *) 0x40004010)
#define          SPI0CON_A                                  0x40004010
// DMA enable register
#define          SPI0DMA                                    (*(volatile unsigned short int *) 0x40004014)
#define          SPI0DMA_A                                  0x40004014
// 8-bit received byte count register
#define          SPI0CNT                                    (*(volatile unsigned short int *) 0x40004018)
#define          SPI0CNT_A                                  0x40004018

// SPI 1

// Status Register
#define          SPI1STA                                    (*(volatile unsigned short int *) 0x40004400)
#define          SPI1STA_A                                  0x40004400
// 8-bit Receive register.
#define          SPI1RX                                     (*(volatile unsigned char      *) 0x40004404)
#define          SPI1RX_A                                   0x40004404
// 8-bit Transmit register
#define          SPI1TX                                     (*(volatile unsigned char      *) 0x40004408)
#define          SPI1TX_A                                   0x40004408
// SPI Clock Divider Registers
#define          SPI1DIV                                    (*(volatile unsigned short int *) 0x4000440C)
#define          SPI1DIV_A                                  0x4000440C
// 16-bit configuration register
#define          SPI1CON                                    (*(volatile unsigned short int *) 0x40004410)
#define          SPI1CON_A                                  0x40004410
// DMA enable register
#define          SPI1DMA                                    (*(volatile unsigned short int *) 0x40004414)
#define          SPI1DMA_A                                  0x40004414
// 8-bit received byte count register
#define          SPI1CNT                                    (*(volatile unsigned short int *) 0x40004418)
#define          SPI1CNT_A                                  0x40004418

// UART

// Transmit Holding register
#define          COMTX                                      (*(volatile unsigned char      *) 0x40005000)
#define          COMTX_A                                    0x40005000
// Receive Buffer register
#define          COMRX                                      (*(volatile unsigned char      *) 0x40005000)
#define          COMRX_A                                    0x40005000
// Interrupt Enable register
#define          COMIEN                                     (*(volatile unsigned char      *) 0x40005004)
#define          COMIEN_A                                   0x40005004
// Interrupt Identification register
#define          COMIIR                                     (*(volatile unsigned char      *) 0x40005008)
#define          COMIIR_A                                   0x40005008
// Line Control register
#define          COMLCR                                     (*(volatile unsigned char      *) 0x4000500C)
#define          COMLCR_A                                   0x4000500C
// Module Control register
#define          COMMCR                                     (*(volatile unsigned char      *) 0x40005010)
#define          COMMCR_A                                   0x40005010
// Line Status register
#define          COMLSR                                     (*(volatile unsigned char      *) 0x40005014)
#define          COMLSR_A                                   0x40005014
// Modem Status register
#define          COMMSR                                     (*(volatile unsigned char      *) 0x40005018)
#define          COMMSR_A                                   0x40005018
// Fractional baud rate divider register.
#define          COMFBR                                     (*(volatile unsigned short int *) 0x40005024)
#define          COMFBR_A                                   0x40005024
// Baud rate Divisor register
#define          COMDIV                                     (*(volatile unsigned short int *) 0x40005028)
#define          COMDIV_A                                   0x40005028
// UART control register
#define          COMCON                                     (*(volatile unsigned char      *) 0x40005030)
#define          COMCON_A                                   0x40005030

// GPIO0

// GPIO Port 0 configuration
#define          GP0CON                                     (*(volatile unsigned short int *) 0x40006000)
#define          GP0CON_A                                   0x40006000
// GPIO Port 0 output enable
#define          GP0OEN                                     (*(volatile unsigned char      *) 0x40006004)
#define          GP0OEN_A                                   0x40006004
// GPIO Port 0 output pull up enable.
#define          GP0PUL                                     (*(volatile unsigned char      *) 0x40006008)
#define          GP0PUL_A                                   0x40006008
// GPIO Port 0 tri state
#define          GP0OCE                                     (*(volatile unsigned char      *) 0x4000600C)
#define          GP0OCE_A                                   0x4000600C
// GPIO Port 0 data input.
#define          GP0IN                                      (*(volatile unsigned char      *) 0x40006014)
#define          GP0IN_A                                    0x40006014
// GPIO Port 0 data out.
#define          GP0OUT                                     (*(volatile unsigned char      *) 0x40006018)
#define          GP0OUT_A                                   0x40006018
// GPIO Port 0 data out set
#define          GP0SET                                     (*(volatile unsigned char      *) 0x4000601C)
#define          GP0SET_A                                   0x4000601C
// GPIO Port 0 data out clear.
#define          GP0CLR                                     (*(volatile unsigned char      *) 0x40006020)
#define          GP0CLR_A                                   0x40006020
// GPIO Port 0 pin toggle.
#define          GP0TGL                                     (*(volatile unsigned char      *) 0x40006024)
#define          GP0TGL_A                                   0x40006024

// GPIO1

// GPIO Port 1 configuration
#define          GP1CON                                     (*(volatile unsigned short int *) 0x40006030)
#define          GP1CON_A                                   0x40006030
// GPIO Port 1 output enable
#define          GP1OEN                                     (*(volatile unsigned char      *) 0x40006034)
#define          GP1OEN_A                                   0x40006034
// GPIO Port 1 output pull up enable.
#define          GP1PUL                                     (*(volatile unsigned char      *) 0x40006038)
#define          GP1PUL_A                                   0x40006038
// GPIO Port 1 tri state
#define          GP1OCE                                     (*(volatile unsigned char      *) 0x4000603C)
#define          GP1OCE_A                                   0x4000603C
// GPIO Port 1 data input.
#define          GP1IN                                      (*(volatile unsigned char      *) 0x40006044)
#define          GP1IN_A                                    0x40006044
// GPIO Port 1 data out.
#define          GP1OUT                                     (*(volatile unsigned char      *) 0x40006048)
#define          GP1OUT_A                                   0x40006048
// GPIO Port 1 data out set
#define          GP1SET                                     (*(volatile unsigned char      *) 0x4000604C)
#define          GP1SET_A                                   0x4000604C
// GPIO Port 1 data out clear.
#define          GP1CLR                                     (*(volatile unsigned char      *) 0x40006050)
#define          GP1CLR_A                                   0x40006050
// GPIO Port 1 pin toggle.
#define          GP1TGL                                     (*(volatile unsigned char      *) 0x40006054)
#define          GP1TGL_A                                   0x40006054

// GPIO2

// GPIO Port 2 configuration
#define          GP2CON                                     (*(volatile unsigned short int *) 0x40006060)
#define          GP2CON_A                                   0x40006060
// GPIO Port 2 output enable
#define          GP2OEN                                     (*(volatile unsigned char      *) 0x40006064)
#define          GP2OEN_A                                   0x40006064
// GPIO Port 2 output pull up enable.
#define          GP2PUL                                     (*(volatile unsigned char      *) 0x40006068)
#define          GP2PUL_A                                   0x40006068
// GPIO Port 2 tri state
#define          GP2OCE                                     (*(volatile unsigned char      *) 0x4000606C)
#define          GP2OCE_A                                   0x4000606C
// GPIO Port 2 data input.
#define          GP2IN                                      (*(volatile unsigned char      *) 0x40006074)
#define          GP2IN_A                                    0x40006074
// GPIO Port 2 data out.
#define          GP2OUT                                     (*(volatile unsigned char      *) 0x40006078)
#define          GP2OUT_A                                   0x40006078
// GPIO Port 2 data out set
#define          GP2SET                                     (*(volatile unsigned char      *) 0x4000607C)
#define          GP2SET_A                                   0x4000607C
// GPIO Port 2 data out clear.
#define          GP2CLR                                     (*(volatile unsigned char      *) 0x40006080)
#define          GP2CLR_A                                   0x40006080
// GPIO Port 2 pin toggle.
#define          GP2TGL                                     (*(volatile unsigned char      *) 0x40006084)
#define          GP2TGL_A                                   0x40006084

// GPIO3

// GPIO Port 3 configuration
#define          GP3CON                                     (*(volatile unsigned short int *) 0x40006090)
#define          GP3CON_A                                   0x40006090
// GPIO Port 3 output enable
#define          GP3OEN                                     (*(volatile unsigned char      *) 0x40006094)
#define          GP3OEN_A                                   0x40006094
// GPIO Port 3 output pull up enable.
#define          GP3PUL                                     (*(volatile unsigned char      *) 0x40006098)
#define          GP3PUL_A                                   0x40006098
// GPIO Port 3 tri state
#define          GP3OCE                                     (*(volatile unsigned char      *) 0x4000609C)
#define          GP3OCE_A                                   0x4000609C
// GPIO Port 3 data input.
#define          GP3IN                                      (*(volatile unsigned char      *) 0x400060A4)
#define          GP3IN_A                                    0x400060A4
// GPIO Port 3 data out.
#define          GP3OUT                                     (*(volatile unsigned char      *) 0x400060A8)
#define          GP3OUT_A                                   0x400060A8
// GPIO Port 3 data out set
#define          GP3SET                                     (*(volatile unsigned char      *) 0x400060AC)
#define          GP3SET_A                                   0x400060AC
// GPIO Port 3 data out clear.
#define          GP3CLR                                     (*(volatile unsigned char      *) 0x400060B0)
#define          GP3CLR_A                                   0x400060B0
// GPIO Port 3 pin toggle.
#define          GP3TGL                                     (*(volatile unsigned char      *) 0x400060B4)
#define          GP3TGL_A                                   0x400060B4

// GPIO4

// GPIO Port 4 configuration
#define          GP4CON                                     (*(volatile unsigned short int *) 0x400060C0)
#define          GP4CON_A                                   0x400060C0
// GPIO Port 4 output enable
#define          GP4OEN                                     (*(volatile unsigned char      *) 0x400060C4)
#define          GP4OEN_A                                   0x400060C4
// GPIO Port 4 output pull up enable.
#define          GP4PUL                                     (*(volatile unsigned char      *) 0x400060C8)
#define          GP4PUL_A                                   0x400060C8
// GPIO Port 4 tri state
#define          GP4OCE                                     (*(volatile unsigned char      *) 0x400060CC)
#define          GP4OCE_A                                   0x400060CC
// GPIO Port 4 data input.
#define          GP4IN                                      (*(volatile unsigned char      *) 0x400060D4)
#define          GP4IN_A                                    0x400060D4
// GPIO Port 4 data out.
#define          GP4OUT                                     (*(volatile unsigned char      *) 0x400060D8)
#define          GP4OUT_A                                   0x400060D8
// GPIO Port 4 data out set
#define          GP4SET                                     (*(volatile unsigned char      *) 0x400060DC)
#define          GP4SET_A                                   0x400060DC
// GPIO Port 4 data out clear.
#define          GP4CLR                                     (*(volatile unsigned char      *) 0x400060E0)
#define          GP4CLR_A                                   0x400060E0
// GPIO Port 4 pin toggle.
#define          GP4TGL                                     (*(volatile unsigned char      *) 0x400060E4)
#define          GP4TGL_A                                   0x400060E4

// Analog ITF

// UHF transceiver test mode access 
#define          RFTST                                      (*(volatile unsigned short int *) 0x40008824)
#define          RFTST_A                                    0x40008824

// uDMA

// Returns the status of the controller when not in the reset state.
#define          DMASTA                                     (*(volatile unsigned long      *) 0x40010000)
#define          DMASTA_A                                   0x40010000
// Configuraton
#define          DMACFG                                     (*(volatile unsigned long      *) 0x40010004)
#define          DMACFG_A                                   0x40010004
// Channel primary control database pointer
#define          DMAPDBPTR                                  (*(volatile unsigned long      *) 0x40010008)
#define          DMAPDBPTR_A                                0x40010008
// Channel alt control database pointer
#define          DMAADBPTR                                  (*(volatile unsigned long      *) 0x4001000C)
#define          DMAADBPTR_A                                0x4001000C
// Channel Software Request
#define          DMASWREQ                                   (*(volatile unsigned long      *) 0x40010014)
#define          DMASWREQ_A                                 0x40010014
// Channel Request Mask Set
#define          DMARMSKSET                                 (*(volatile unsigned long      *) 0x40010020)
#define          DMARMSKSET_A                               0x40010020
// Channel Request Mask Clear
#define          DMARMSKCLR                                 (*(volatile unsigned long      *) 0x40010024)
#define          DMARMSKCLR_A                               0x40010024
// Channel Enable Set
#define          DMAENSET                                   (*(volatile unsigned long      *) 0x40010028)
#define          DMAENSET_A                                 0x40010028
// Channel Enable Clear
#define          DMAENCLR                                   (*(volatile unsigned long      *) 0x4001002C)
#define          DMAENCLR_A                                 0x4001002C
// Channel Primary-Alternate Set
#define          DMAALTSET                                  (*(volatile unsigned long      *) 0x40010030)
#define          DMAALTSET_A                                0x40010030
// Channel Primary-Alternate Clear
#define          DMAALTCLR                                  (*(volatile unsigned long      *) 0x40010034)
#define          DMAALTCLR_A                                0x40010034
// Channel Priority Set
#define          DMAPRISET                                  (*(volatile unsigned long      *) 0x40010038)
#define          DMAPRISET_A                                0x40010038
// Channel Priority Clear
#define          DMAPRICLR                                  (*(volatile unsigned long      *) 0x4001003C)
#define          DMAPRICLR_A                                0x4001003C
// Bus Error Clear
#define          DMAERRCLR                                  (*(volatile unsigned long      *) 0x4001004C)
#define          DMAERRCLR_A                                0x4001004C
// Peripheral identification 4
#define          DMAPERID4                                  (*(volatile unsigned char      *) 0x40010FD0)
#define          DMAPERID4_A                                0x40010FD0
// Peripheral identification 0
#define          DMAPERID0                                  (*(volatile unsigned char      *) 0x40010FE0)
#define          DMAPERID0_A                                0x40010FE0
// Peripheral identification 1
#define          DMAPERID1                                  (*(volatile unsigned char      *) 0x40010FE4)
#define          DMAPERID1_A                                0x40010FE4
// Peripheral identification 2
#define          DMAPERID2                                  (*(volatile unsigned char      *) 0x40010FE8)
#define          DMAPERID2_A                                0x40010FE8
// Peripheral identification 3
#define          DMAPERID3                                  (*(volatile unsigned char      *) 0x40010FEC)
#define          DMAPERID3_A                                0x40010FEC
// PrimeCell identification 0
#define          DMAPCELLID0                                (*(volatile unsigned char      *) 0x40010FF0)
#define          DMAPCELLID0_A                              0x40010FF0
// PrimeCell identification 1
#define          DMAPCELLID1                                (*(volatile unsigned char      *) 0x40010FF4)
#define          DMAPCELLID1_A                              0x40010FF4
// PrimeCell identification 2
#define          DMAPCELLID2                                (*(volatile unsigned char      *) 0x40010FF8)
#define          DMAPCELLID2_A                              0x40010FF8
// PrimeCell identification 3
#define          DMAPCELLID3                                (*(volatile unsigned char      *) 0x40010FFC)
#define          DMAPCELLID3_A                              0x40010FFC

// NVIC

// Shows the number of interrupt lines that the NVIC supports
#define          ICTR                                       (*(volatile unsigned long      *) 0xE000E004)
#define          ICTR_A                                     0xE000E004
// SysTick Control and Status Register
#define          STCSR                                      (*(volatile unsigned long      *) 0xE000E010)
#define          STCSR_A                                    0xE000E010
// SysTick Reload Value Register
#define          STRVR                                      (*(volatile unsigned long      *) 0xE000E014)
#define          STRVR_A                                    0xE000E014
// SysTick Current Value Register
#define          STCVR                                      (*(volatile unsigned long      *) 0xE000E018)
#define          STCVR_A                                    0xE000E018
// SysTick Calibration Value Register
#define          STCR                                       (*(volatile unsigned long      *) 0xE000E01C)
#define          STCR_A                                     0xE000E01C
// IRQ0..31 Set_Enable 
#define          ISER0                                      (*(volatile unsigned long      *) 0xE000E100)
#define          ISER0_A                                    0xE000E100
// IRQ32..63 Set_Enable 
#define          ISER1                                      (*(volatile unsigned long      *) 0xE000E104)
#define          ISER1_A                                    0xE000E104
// IRQ0..31 Clear_Enable 
#define          ICER0                                      (*(volatile unsigned long      *) 0xE000E180)
#define          ICER0_A                                    0xE000E180
// IRQ32..63 Clear_Enable 
#define          ICER1                                      (*(volatile unsigned long      *) 0xE000E184)
#define          ICER1_A                                    0xE000E184
// IRQ0..31 Set_Pending 
#define          INTSETP0                                   (*(volatile unsigned long      *) 0xE000E200)
#define          INTSETP0_A                                 0xE000E200
// IRQ32..63 Set_Pending 
#define          INTSETP1                                   (*(volatile unsigned long      *) 0xE000E204)
#define          INTSETP1_A                                 0xE000E204
// IRQ0..31 Clear_Pending 
#define          ICPR0                                      (*(volatile unsigned long      *) 0xE000E280)
#define          ICPR0_A                                    0xE000E280
// IRQ32..63 Clear_Pending 
#define          ICPR1                                      (*(volatile unsigned long      *) 0xE000E284)
#define          ICPR1_A                                    0xE000E284
// IRQ0..31 Active Bit 
#define          IABR0                                      (*(volatile unsigned long      *) 0xE000E300)
#define          IABR0_A                                    0xE000E300
// IRQ32..63 Active Bit 
#define          IABR1                                      (*(volatile unsigned long      *) 0xE000E304)
#define          IABR1_A                                    0xE000E304
// IRQ0..3 Priority 
#define          IPR0                                       (*(volatile unsigned long      *) 0xE000E400)
#define          IPR0_A                                     0xE000E400
// IRQ4..7 Priority 
#define          IPR1                                       (*(volatile unsigned long      *) 0xE000E404)
#define          IPR1_A                                     0xE000E404
// IRQ8..11 Priority 
#define          IPR2                                       (*(volatile unsigned long      *) 0xE000E408)
#define          IPR2_A                                     0xE000E408
// IRQ12..15 Priority 
#define          IPR3                                       (*(volatile unsigned long      *) 0xE000E40C)
#define          IPR3_A                                     0xE000E40C
// IRQ16..19 Priority 
#define          IPR4                                       (*(volatile unsigned long      *) 0xE000E410)
#define          IPR4_A                                     0xE000E410
// IRQ20..23 Priority 
#define          IPR5                                       (*(volatile unsigned long      *) 0xE000E414)
#define          IPR5_A                                     0xE000E414
// IRQ24..27 Priority 
#define          IPR6                                       (*(volatile unsigned long      *) 0xE000E418)
#define          IPR6_A                                     0xE000E418
// IRQ28..31 Priority 
#define          IPR7                                       (*(volatile unsigned long      *) 0xE000E41C)
#define          IPR7_A                                     0xE000E41C
// IRQ32..35 Priority 
#define          IPR8                                       (*(volatile unsigned long      *) 0xE000E420)
#define          IPR8_A                                     0xE000E420
// IRQ36..39 Priority 
#define          IPR9                                       (*(volatile unsigned long      *) 0xE000E424)
#define          IPR9_A                                     0xE000E424
// IRQ40..43 Priority 
#define          IPR10                                      (*(volatile unsigned long      *) 0xE000E428)
#define          IPR10_A                                    0xE000E428
// CPUID Base
#define          CPUID                                      (*(volatile unsigned long      *) 0xE000ED00)
#define          CPUID_A                                    0xE000ED00
// Interrupt Control and State Register
#define          ICSR                                       (*(volatile unsigned long      *) 0xE000ED04)
#define          ICSR_A                                     0xE000ED04
// Vector Table Offset Register
#define          VTOR                                       (*(volatile unsigned long      *) 0xE000ED08)
#define          VTOR_A                                     0xE000ED08
// Application Interrupt and Reset Control Register
#define          AIRCR                                      (*(volatile unsigned long      *) 0xE000ED0C)
#define          AIRCR_A                                    0xE000ED0C
// System Control Register
#define          SCR                                        (*(volatile unsigned long      *) 0xE000ED10)
#define          SCR_A                                      0xE000ED10
// Configuration Control
#define          CCR                                        (*(volatile unsigned long      *) 0xE000ED14)
#define          CCR_A                                      0xE000ED14
// System Handler Priority Register 1
#define          SHPR1                                      (*(volatile unsigned long      *) 0xE000ED18)
#define          SHPR1_A                                    0xE000ED18
// System Handler Priority Register 2
#define          SHPR2                                      (*(volatile unsigned long      *) 0xE000ED1C)
#define          SHPR2_A                                    0xE000ED1C
// System Handler Priority Register 3
#define          SHPR3                                      (*(volatile unsigned long      *) 0xE000ED20)
#define          SHPR3_A                                    0xE000ED20
// System Handler Control and State
#define          SHCSR                                      (*(volatile unsigned long      *) 0xE000ED24)
#define          SHCSR_A                                    0xE000ED24
// Configurable Fault Status
#define          CFSR                                       (*(volatile unsigned long      *) 0xE000ED28)
#define          CFSR_A                                     0xE000ED28
// Hard Fault Status
#define          HFSR                                       (*(volatile unsigned long      *) 0xE000ED2C)
#define          HFSR_A                                     0xE000ED2C
// Mem Manage Address
#define          MMFAR                                      (*(volatile unsigned long      *) 0xE000ED34)
#define          MMFAR_A                                    0xE000ED34
// Bus Fault Address
#define          BFAR                                       (*(volatile unsigned long      *) 0xE000ED38)
#define          BFAR_A                                     0xE000ED38
// Software Trigger Interrupt Register
#define          STIR                                       (*(volatile unsigned long      *) 0xE000EF00)
#define          STIR_A                                     0xE000EF00

// SAR ADC

// ADC Configuration Register                      
#define          ADCCFG                                     (*(volatile unsigned short int *) 0x40050000)
#define          ADCCFG_A                                   0x40050000
// ADC Control
#define          ADCCON                                     (*(volatile unsigned char      *) 0x40050004)
#define          ADCCON_A                                   0x40050004
// ADC Status                 
#define          ADCSTA                                     (*(volatile unsigned char      *) 0x40050008)
#define          ADCSTA_A                                   0x40050008
// ADC Data                      
#define          ADCDAT                                     (*(volatile unsigned short int *) 0x4005000C)
#define          ADCDAT_A                                   0x4005000C
// ADC GAIN                 
#define          ADCGN                                      (*(volatile unsigned short int *) 0x40050010)
#define          ADCGN_A                                    0x40050010
// ADC Offset               
#define          ADCOF                                      (*(volatile unsigned short int *) 0x40050014)
#define          ADCOF_A                                    0x40050014

// High Frequency Oscillator Trim (Rev C Only)

// Status register (Rev C Only)
#define          HFTSTA                                     (*(volatile unsigned char      *) 0x40009C00)
#define          HFTSTA_A                                   0x40009C00
// Control Register (Rev C Only)
#define          HFTCON                                     (*(volatile unsigned char      *) 0x40009C04)
#define          HFTCON_A                                   0x40009C04
// Maximum calibration value (Rev C Only)
#define          HFTMAX                                     (*(volatile unsigned char      *) 0x40009C08)
#define          HFTMAX_A                                   0x40009C08
// Minimum calibration value (Rev C Only)
#define          HFTMIN                                     (*(volatile unsigned char      *) 0x40009C0C)
#define          HFTMIN_A                                   0x40009C0C
// Oscillator trim value (Rev C Only)
#define          HFTTRM                                     (*(volatile unsigned char      *) 0x40009C10)
#define          HFTTRM_A                                   0x40009C10
// Xtal target count (Rev C Only)
#define          HFTXMAX                                    (*(volatile unsigned char      *) 0x40009C14)
#define          HFTXMAX_A                                  0x40009C14
// XTAL current count (Rev C Only)
#define          HFTXVAL                                    (*(volatile unsigned char      *) 0x40009C18)
#define          HFTXVAL_A                                  0x40009C18
// UCLK target count (Rev C Only)
#define          HFTUMAX                                    (*(volatile unsigned short int *) 0x40009C1C)
#define          HFTUMAX_A                                  0x40009C1C
// UCLK current count (Rev C Only)
#define          HFTUVAL                                    (*(volatile unsigned short int *) 0x40009C20)
#define          HFTUVAL_A                                  0x40009C20
